<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use App\Repositories\Report\ReportInterface;
use Illuminate\Http\Request;
use Auth;

class UserMaintenanceController extends Controller
{
    private $report;

    public function __construct(ReportInterface $report)
    {
        $this->report = $report;
    }

    public function index(Request $request)
    {
        $user=Auth::user();
        $maintenances = $this->report->GetAllMaintenances($user);
        // dd($user->id);
        // dd($maintenances);
        //dd($audits);
        return view('reports.users.maintenances.index', compact('maintenances'))->with('i', ($request->input('page', 1) - 1)* 5);
    }
}
