<!doctype html>
<html lang="en" class="no-focus">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">

        <title>Verify - National Central Tower</title>

        <meta name="description" content="national central tower powered by frm">
        <meta name="author" content="pixelcave">
        <meta name="robots" content="noindex, nofollow">

        <!-- Graph Meta -->
        <meta property="og:title" content="national central tower powered by frm">
        <meta property="og:site_name" content="national central tower">
        <meta property="og:description" content="national central tower powered by frm">
        <meta property="og:type" content="website">
        <meta property="og:url" content="">
        <meta property="og:image" content="">

        <!-- Icons -->
        <!-- The following icons can be replaced with your own, they are used by desktop and mobile browsers -->
        <link rel="shortcut icon" href="<?php echo e(asset('media/favicons/favicon.png')); ?>">
        <link rel="icon" type="image/png" sizes="192x192" href="<?php echo e(asset('media/favicons/favicon-192x192.png')); ?>">
        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('media/favicons/apple-touch-icon-180x180.png')); ?>">
        <!-- END Icons -->

        <!-- Stylesheets -->

        <!-- Fonts and Codebase framework -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Muli:300,400,400i,600,700">
        <link rel="stylesheet" id="css-main" href="<?php echo e(asset('css/codebase.css')); ?>">

        <!-- You can include a specific file from css/themes/ folder to alter the default color theme of the template. eg: -->
        <!-- <link rel="stylesheet" id="css-theme" href="assets/css/themes/flat.min.css"> -->
        <!-- END Stylesheets -->
        <style>
            .invalid-feedback{
                display: block;
            }

            .is-invalid {
                box-shadow: 0 1px 0 #ef5350 !important;
            }
        </style>
    </head>
    <body>

        <!-- Page Container -->
        <!--
            Available classes for #page-container:

        GENERIC

            'enable-cookies'                            Remembers active color theme between pages (when set through color theme helper Template._uiHandleTheme())

        SIDEBAR & SIDE OVERLAY

            'sidebar-r'                                 Right Sidebar and left Side Overlay (default is left Sidebar and right Side Overlay)
            'sidebar-mini'                              Mini hoverable Sidebar (screen width > 991px)
            'sidebar-o'                                 Visible Sidebar by default (screen width > 991px)
            'sidebar-o-xs'                              Visible Sidebar by default (screen width < 992px)
            'sidebar-inverse'                           Dark themed sidebar

            'side-overlay-hover'                        Hoverable Side Overlay (screen width > 991px)
            'side-overlay-o'                            Visible Side Overlay by default

            'enable-page-overlay'                       Enables a visible clickable Page Overlay (closes Side Overlay on click) when Side Overlays

            'side-scroll'                               Enables custom scrolling on Sidebar and Side Overlay instead of native scrolling (screen width > 991px)

        HEADER

            ''                                          Static Header if no class is added
            'page-header-fixed'                         Fixed Header

        HEADER STYLE

            ''                                          Classic Header style if no class is added
            'page-header-modern'                        Modern Header style
            'page-header-inverse'                       Dark themed Header (works only with classic Header style)
            'page-header-glass'                         Light themed Header with transparency by default
                                                        (absolute position, perfect for light images underneath - solid light background on scroll if the Header is also set as fixed)
            'page-header-glass page-header-inverse'     Dark themed Header with transparency by default
                                                        (absolute position, perfect for dark images underneath - solid dark background on scroll if the Header is also set as fixed)

        MAIN CONTENT LAYOUT

            ''                                          Full width Main Content if no class is added
            'main-content-boxed'                        Full width Main Content with a specific maximum width (screen width > 1200px)
            'main-content-narrow'                       Full width Main Content with a percentage width (screen width > 1200px)
        -->
        <div id="page-container" class="main-content-boxed">

            <!-- Main Container -->
            <main id="main-container">
                <!-- Fade In Modal -->
                <div class="modal fade show" id="modal-large" tabindex="-1" role="dialog" aria-labelledby="modal-large" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="block block-themed block-transparent mb-0">
                                <div class="block-header bg-primary-dark">
                                    <h3 class="block-title">GENERAL INFORMATION</h3>
                                    <div class="block-options">
                                        <button type="button" class="btn-block-option" data-dismiss="modal" aria-label="Close">
                                            <i class="si si-close"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="block-content">

                                    <div class="d-flex flex-wrap">
                                        <div class="block m-1">
                                            <div class="block-header block-header-default">Requirements for Tower Maintenance Firm</div>
                                            <div class="block-content">
                                                <ol>
                                                    <li>NCC Operating License.</li>
                                                    <li>Towersite Maintenance Report Analysis System.</li>
                                                    <li>Siaxou Coordinates Matcher System. link</li>
                                                </ol>
                                            </div>
                                        </div>
                                        <div class="block m-1">
                                            <div class="block-header block-header-default">Requirements for Tower Insurance Firm</div>
                                            <div class="block-content">
                                                <ol>
                                                    <li>Sitee Call Verifi System. link</li>
                                                    <li>General Insurance Operating License from NAICOM.</li>
                                                </ol>
                                            </div>
                                        </div>
                                        <div class="block m-1">
                                            <div class="block-header block-header-default">Requirements for Tower Audit Firm:</div>
                                            <div class="block-content">
                                                <ol>
                                                    <li>NCC Equipment Type Approval.</li>
                                                    <li>Office of National Security Adviser UAV Clearance.</li>
                                                    <li>Ability to operate UAV on ISM Band Frequency.</li>
                                                    <li>Geek UAV Tower Flight Plan System.</li>
                                                    <li>Siaxou Tower Coordinates Matcher System.</li>
                                                    <li>Hangar Tower Audit Report Extraction & Analysis System.</li>
                                                    <li>Sitesee UAV Radiation Sensor System.</li>
                                                </ol>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-alt-secondary" data-dismiss="modal">Close</button>
                                <button type="button" class="btn btn-alt-success" data-dismiss="modal">
                                    <i class="fa fa-check"></i> Ok
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- END Fade In Modal -->
                                <!-- Page Content -->
                <div class="bg-image" style="background-image: url(<?php echo e(asset('media/photos/photo34@2x.jpg')); ?>);">

                    <div class="row mx-0 bg-black-op" data-toggle="appear">
                        <div class="hero-static flex-column col-md-6 col-xl-8 d-none d-md-flex align-items-md-end">
                            <div class="d-flex m-auto">
                                <div class="block">
                                    <div class="block-header block-header-default">GENERAL INFORMATION</div>
                                    <div class="block-content">
                                        <div class="d-flex">
                                            <div class="block m-1">
                                                <div class="block-header block-header-default">Requirements for Tower Maintenance Firm</div>
                                                <div class="block-content">
                                                    <ol>
                                                        <li>NCC Operating License.</li>
                                                        <li>Towersite Maintenance Report Analysis System.</li>
                                                        <li>Siaxou Coordinates Matcher System. link</li>
                                                    </ol>
                                                </div>
                                            </div>
                                            <div class="block m-1">
                                                <div class="block-header block-header-default">Requirements for Tower Insurance Firm</div>
                                                <div class="block-content">
                                                    <ol>
                                                        <li>Sitee Call Verifi System. link</li>
                                                        <li>General Insurance Operating License from NAICOM.</li>
                                                    </ol>
                                                </div>
                                            </div>
                                            <div class="block m-1">
                                                <div class="block-header block-header-default">Requirements for Tower Audit Firm:</div>
                                                <div class="block-content">
                                                    <ol>
                                                        <li>NCC Equipment Type Approval.</li>
                                                        <li>Office of National Security Adviser UAV Clearance.</li>
                                                        <li>Ability to operate UAV on ISM Band Frequency.</li>
                                                        <li>Geek UAV Tower Flight Plan System.</li>
                                                        <li>Siaxou Tower Coordinates Matcher System.</li>
                                                        <li>Hangar Tower Audit Report Extraction & Analysis System.</li>
                                                        <li>Sitesee UAV Radiation Sensor System.</li>
                                                    </ol>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="p-3 invisible mt-auto" data-toggle="appear">
                                <p class="font-size-h3 mb-1 font-w600 text-white">
                                    National Central Tower
                                </p>
                                <p class="font-italic text-white-op">
                                    Copyright &copy; <span class="js-year-copy"></span> Powered by FRM
                                </p>
                            </div>
                        </div>
                        <div class="hero-static col-md-6 col-xl-4 d-flex align-items-center bg-white invisible" data-toggle="appear" data-class="animated fadeInRight">
                            <div class="content content-full">
                                <!-- Header -->
                                <div class="px-30 py-10">
                                    <a class="link-effect font-w700" href="/">
                                        <img src="<?php echo e(asset('media/photos/ncc-logo.png')); ?>" style="height:50px; width:auto;" alt="">
                                        
                                    </a>
                                    <div class="card-header"><?php echo e(__('Verify Your Email Address by updating your Profile')); ?></div>

                                    <div class="card-body">
                                        <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                       <i class="si si-logout mr-5"></i> <?php echo e(__('Logout')); ?>

                                    </a>


                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                        <?php if(isset($user)): ?>
                                        <?php if($user): ?>
                                            <form action="<?php echo e($url.'?'.http_build_query($query)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <div class="form-group row">
                                                    <div class="col-xs-12 col-sm-12 col-md-12">
                                                        <div class="form-material floating open">
                                                            <input id="email" type="email" readonly class="form-control-plaintext <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e($user->email); ?>">
                                                            <label for="email" class=""><?php echo e(__('Email Address')); ?></label>
                                                        </div>
                                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong><?php echo e($message); ?></strong>
                                                            </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <div class="col-xs-4 col-sm-4 col-md-4">
                                                        <div class="form-material floating open">
                                                            <input id="firstname" type="text" readonly class="form-control-plaintext <?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="firstname" value="<?php echo e($user->firstname); ?>">
                                                            <label for="firstname" class=""><?php echo e(__('First Name')); ?></label>
                                                        </div>
                                                        <?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong><?php echo e($message); ?></strong>
                                                            </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                    <div class="col-xs-4 col-sm-4 col-md-4">
                                                        <div class="form-material floating open">
                                                            <input id="othernames" type="text" readonly class="form-control-plaintext <?php $__errorArgs = ['othernames'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="othernames" value="<?php echo e($user->othernames); ?>">
                                                            <label for="othernames" class=""><?php echo e(__('Other Name')); ?></label>
                                                        </div>
                                                        <?php $__errorArgs = ['othernames'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong><?php echo e($message); ?></strong>
                                                            </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                    <div class="col-xs-4 col-sm-4 col-md-4">
                                                        <div class="form-material floating open">
                                                            <input id="lastname" type="text" readonly class="form-control-plaintext <?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="lastname" value="<?php echo e($user->lastname); ?>">
                                                            <label for="lastname" class=""><?php echo e(__('Last Name')); ?></label>
                                                        </div>
                                                        <?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong><?php echo e($message); ?></strong>
                                                            </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <div class="col-xs-12 col-sm-12 col-md-12">
                                                        <div class="form-material floating">
                                                            <input id="username" type="text" class="form-control <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="username" value="<?php echo e(old('username')); ?>" autofocus>
                                                            <label for="username" class=""><?php echo e(__('Username')); ?></label>
                                                        </div>
                                                        <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong><?php echo e($message); ?></strong>
                                                            </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <div class="col-xs-12 col-sm-12 col-md-12">
                                                        <div class="form-material floating">
                                                            <input id="password" type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" value="<?php echo e(old('password')); ?>">
                                                            <label for="password" class=""><?php echo e(__('Password')); ?></label>
                                                        </div>
                                                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong><?php echo e($message); ?></strong>
                                                            </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <div class="col-xs-12 col-sm-12 col-md-12">
                                                        <div class="form-material floating">
                                                            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" value="<?php echo e(old('password_confirmation')); ?>">
                                                            <label for="password-confirm" class=""><?php echo e(__('Confirm Password')); ?></label>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="form-group row mb-0">
                                                    <div class="col-md-8 offset-md-4">
                                                        <button type="submit" class="btn btn-primary">
                                                            <?php echo e(__('Update')); ?>

                                                        </button>

                                                        
                                                    </div>
                                                </div>
                                            </form>
                                        <?php else: ?>
                                            <?php if(session('resent')): ?>
                                                <div class="alert alert-success" role="alert">
                                                    <?php echo e(__('A fresh verification link has been sent to your email address.')); ?>

                                                </div>
                                            <?php endif; ?>
                                            <?php echo e(__('Before proceeding, please check your email for a verification link.')); ?>

                                            <?php echo e(__('If you did not receive the email')); ?>,
                                            <form class="d-inline" method="POST" action="<?php echo e(route('verification.resend')); ?>">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-link p-0 m-0 align-baseline"><?php echo e(__('click here to request another')); ?></button>.
                                            </form>
                                        <?php endif; ?>
                                        <?php else: ?>
                                            <?php if(session('resent')): ?>
                                                <div class="alert alert-success" role="alert">
                                                    <?php echo e(__('A fresh verification link has been sent to your email address.')); ?>

                                                </div>
                                            <?php endif; ?>
                                            <?php echo e(__('Before proceeding, please check your email for a verification link.')); ?>

                                            <?php echo e(__('If you did not receive the email')); ?>,
                                            <form class="d-inline" method="POST" action="<?php echo e(route('verification.resend')); ?>">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-link p-0 m-0 align-baseline"><?php echo e(__('click here to request another')); ?></button>.
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <!-- END Header -->
                                <!-- Sign In Form -->
                                <!-- jQuery Validation functionality is initialized with .js-validation-signin class in js/pages/op_auth_signin.min.js which was auto compiled from _es6/pages/op_auth_signin.js -->
                                <!-- For more examples you can check out https://github.com/jzaefferer/jquery-validation -->
                            </div>
                        </div>
                    </div>
                </div>
                <!-- END Page Content -->
            </main>
            <!-- END Main Container -->
        </div>
        <!-- END Page Container -->
        <!--
        Codebase JS Core

        Vital libraries and plugins used in all pages. You can choose to not include this file if you would like
        to handle those dependencies through webpack. Please check out assets/_es6/main/bootstrap.js for more info.

        If you like, you could also include them separately directly from the assets/js/core folder in the following
        order. That can come in handy if you would like to include a few of them (eg jQuery) from a CDN.

        assets/js/core/jquery.min.js
        assets/js/core/bootstrap.bundle.min.js
        assets/js/core/simplebar.min.js
        assets/js/core/jquery-scrollLock.min.js
        assets/js/core/jquery.appear.min.js
        assets/js/core/jquery.countTo.min.js
        assets/js/core/js.cookie.min.js
        -->
        <script src="<?php echo e(asset('js/codebase.core.js')); ?>"></script>
        <!--
        Codebase JS

        Custom functionality including Blocks/Layout API as well as other vital and optional helpers
        webpack is putting everything together at assets/_es6/main/app.js
        -->
        <script src="<?php echo e(asset('js/codebase.app.js')); ?>"></script>

        <!-- Page JS Plugins -->
        <script src="<?php echo e(asset('js/plugins/jquery-validation/jquery.validate.min.js')); ?>"></script>

        <!-- Page JS Code -->
        <script src="<?php echo e(asset('js/pages/op_auth_signin.js')); ?>"></script>
        <script>
            window.localStorage.setItem('pass', "123456")
            const username = document.querySelector("#email");
            const password = document.querySelector("#password");
            const LoginForm = document.querySelector("#LofinForm");
            LoginForm.addEventListener("submit", function(e){
                e.preventDefault()
                debugger;
                if (username.value !== "" && password.value !== ""){
                    this.submit();
                }
            });
            $(document).ready(function(){

            jQuery('#modal-large').modal('show');
            });
        </script>
    </body>
</html>
<?php /**PATH /home/ncaa/public_html/resources/views/auth/verify.blade.php ENDPATH**/ ?>