<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\Pivot;

class AuditAgentUser extends Pivot
{
    //
    protected $table = 'audit_agent_user';

    public $incrementing = true;

    public function user ()
    {
        return $this->belongsTo("App\User");
    }

    public function auditagenttower ()
    {
        return $this->belongsTo("App\AuditAgentTower");
    }

    public function auditagents ()
    {
        return $this->belongsTo("App\AuditAgent", "audit_agent_id");
    }
}
