<style>
    body {
    font-family: Arial, sans-serif;
}

.container {
    max-width: 800px;
    margin: 20px auto;
}

table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
}

table, th, td {
    border: 1px solid #ddd;
}

th, td {
    padding: 12px;
    text-align: left;
}

th {
    background-color: #f2f2f2;
}

.search-container {
    margin-bottom: 20px;
}
 
.pagination {
    margin-top: 20px;
    
}

.pagination button {
    background-color: #4CAF50;
    color: white;
    padding: 10px;
    border: none;
    cursor: pointer;
}

.pagination button:hover {
    background-color: #45a049;
}

</style>
@extends('layouts.report')

@section('content')
    <div class="container">
    <h2 class="content-heading">Report <small>view insurance report</small></h2>
    <!-- <h2 class="table-header">Tower Report</h2> -->
        
        <div class="container">
    <h2>Insurance Records</h2>

    <div class="search-container">
        <input type="text" id="searchInput" onkeyup="filterTable()" placeholder="Search...">
    </div>

    <table id="insuranceTable">
        <!-- Table content will be loaded dynamically using JavaScript -->
    </table>

    <div class="pagination">
        <button onclick="previousPage()">Previous</button>
        <span id="pageNumbers"></span>
        <button onclick="nextPage()">Next</button>
    </div>
</div>

<script src="scripts.js"></script>
        <script>
            // Variables for pagination
let currentPage = 1;
const recordsPerPage = 5; // Adjust as needed

document.addEventListener("DOMContentLoaded", function() {
    // Load the initial page
    loadTableData();

    // Update page numbers
    updatePageNumbers();
});

function filterTable() {
    const input = document.getElementById("searchInput");
    const filter = input.value.toUpperCase();
    const table = document.getElementById("insuranceTable");
    const rows = table.getElementsByTagName("tr");

    for (let i = 0; i < rows.length; i++) {
        const cells = rows[i].getElementsByTagName("td");
        let shouldShow = false;

        for (let j = 0; j < cells.length; j++) {
            const cellText = cells[j].textContent || cells[j].innerText;

            if (cellText.toUpperCase().indexOf(filter) > -1) {
                shouldShow = true;
                break;
            }
        }

        rows[i].style.display = shouldShow ? "" : "none";
    }
}

function loadTableData() {
    const table = document.getElementById("insuranceTable");
    const start = (currentPage - 1) * recordsPerPage;
    const end = start + recordsPerPage;

    // AJAX request to fetch data from the server
    // Replace 'your_server', 'your_username', 'your_password', and 'your_database' with your actual database details
    const xhr = new XMLHttpRequest();
    xhr.open("GET", `fetch_data.php?start=${start}&end=${end}`, true);
    xhr.onreadystatechange = function() {
        if (xhr.readyState == 4 && xhr.status == 200) {
            const data = JSON.parse(xhr.responseText);
            displayTableData(data);
        }
    };
    xhr.send();
}

function displayTableData(data) {
    const table = document.getElementById("insuranceTable");
    const headerRow = table.insertRow(0);

    for (const column in data[0]) {
        const headerCell = headerRow.insertCell();
        headerCell.textContent = column;
    }

    for (let i = 0; i < data.length; i++) {
        const row = table.insertRow(i + 1);

        for (const column in data[i]) {
            const cell = row.insertCell();
            cell.textContent = data[i][column];
        }
    }
}

function updatePageNumbers() {
    const xhr = new XMLHttpRequest();
    xhr.open("GET", "count_records.php", true);
    xhr.onreadystatechange = function() {
        if (xhr.readyState == 4 && xhr.status == 200) {
            const totalRecords = parseInt(xhr.responseText);
            const totalPages = Math.ceil(totalRecords / recordsPerPage);

            let pageNumbers = "";
            const startPage = Math.max(1, currentPage - 3);
            const endPage = Math.min(totalPages, startPage + 6);

            for (let i = startPage; i <= endPage; i++) {
                pageNumbers += `<button onclick="goToPage(${i})">${i}</button>`;
            }

            document.getElementById("pageNumbers").innerHTML = pageNumbers;
        }
    };
    xhr.send();
}

function previousPage() {
    if (currentPage > 1) {
        currentPage--;
        loadTableData();
        updatePageNumbers();
    }
}

function nextPage() {
    // You may need to adjust the condition based on your specific needs
    if (currentPage < 3) {
        currentPage++;
        loadTableData();
        updatePageNumbers();
    }
}

function goToPage(page) {
    currentPage = page;
    loadTableData();
    updatePageNumbers();
}

        </script>
        
                </div>
            </div>
@endsection

@section('js_after')
@endsection
