@extends('layouts.backend')

@section('content')
<div class="content">
          <div class="row">
            <!-- Row #1 -->
            <div class="col-6 col-md-4 col-xl-4">
              <a class="block block-rounded text-center" href="{{route('reports.aircrafts.index')}}">
                <div class="block-content ribbon ribbon-bookmark ribbon-glass ribbon-left bg-gd-dusk">
                  <div class="ribbon-box">{{ $towercount }}</div>
                  <p class="mt-2 mb-3">
                    <i class="si si-bar-chart fa-2x text-white-75"></i>
                  </p>
                  <p class="fw-semibold text-white">Aircrafts</p>
                </div>
              </a>
            </div>
            <div class="col-6 col-md-4 col-xl-2">
              <a class="block block-rounded text-center" href="{{route('reports.tenants.index')}}">
                <div class="block-content ribbon ribbon-bookmark ribbon-glass ribbon-left bg-gd-dusk">
                <div class="ribbon-box">{{$tenantcount}}</div>
                  <p class="mt-2 mb-3">
                    <i class="si si-bar-chart fa-2x text-white-75"></i>
                  </p>
                  <p class="fw-semibold text-white">Crews</p>
                </div>
              </a>
            </div>
            <div class="col-6 col-md-4 col-xl-2">
              <a class="block block-rounded text-center" href="{{route('reports.RoutineMaintanance.index')}}">
                <div class="block-content ribbon ribbon-bookmark ribbon-glass ribbon-left bg-gd-sea">
                  <div class="ribbon-box">{{$maintenancecount}}</div>
                  <p class="mt-2 mb-3">
                    <i class="si si-bar-chart fa-2x text-white-75"></i>
                  </p>
                  <p class="fw-semibold text-white">Routine Maintenance</p>
                </div>
              </a>
            </div>
            <div class="col-6 col-md-4 col-xl-2">
              <a class="block block-rounded text-center" href="{{route('reports.ScheduledMaintanance.index')}}">
                <div class="block-content ribbon ribbon-bookmark ribbon-glass ribbon-left bg-gd-lake">
                <div class="ribbon-box">{{$auditcount}}</div>
                  <p class="mt-2 mb-3">
                    <i class="si si-bar-chart fa-2x text-white-75"></i>
                  </p>
                  <p class="fw-semibold text-white">Scheduled Maintenance
</p>
                </div>
              </a>
            </div>
            <div class="col-6 col-md-4 col-xl-2">
              <a class="block block-rounded text-center" href="{{route('reports.insurances.index')}}">
                <div class="block-content ribbon ribbon-bookmark ribbon-glass ribbon-left bg-gd-emerald">
                <div class="ribbon-box">{{$insurancecount}}</div>
                  <p class="mt-2 mb-3">
                    <i class="si si-bar-chart fa-2x text-white-75"></i>
                  </p>
                  <p class="fw-semibold text-white">Insurance</p>
                </div>
              </a>
            </div>
           
            <!-- END Row #1 -->
          </div>
        
          <div class="row">
            <!-- Row #4 -->
            <div class="col-md-6">
              <a class="block block-rounded">
                <div class="block-content block-content-full">
                  <!-- <i class="si si-game-controller fa-2x text-pulse"></i> -->
                  <div class="fs-sm fw-semibold text-uppercase">Routine Maintenance </div>
                  <div class="row py-3 text-center">
                    <div class="col-6 border-end">
                      <div class="fs-3 fw-semibold">{{$towerWeeklyCount}}</div>
                      <div class="fs-sm fw-semibold text-uppercase text-muted">This Week</div>
                    </div>
                    <div class="col-6">
                      <div class="fs-3 fw-semibold">{{$towerMonthlyCount}}</div>
                      <div class="fs-sm fw-semibold text-uppercase text-muted">This Month</div>
                    </div>
                  </div>
                </div>
              </a>
            </div>
            <div class="col-md-6">
              <a class="block block-rounded">
                <div class="block-content block-content-full">
                  <div class="text-end">
                    <!-- <i class="si si-wallet fa-2x text-success"></i> -->
                    <div class="fs-sm fw-semibold text-uppercase">Scheduled Maintenance</div>
                  </div>
                  <div class="row py-3 text-center">
                    <div class="col-6 border-end">
                      <div class="fs-3 fw-semibold">{{$auditWeeklyCount}}</div>
                      <div class="fs-sm fw-semibold text-uppercase text-muted">This week</div>
                    </div>
                    <div class="col-6">
                      <div class="fs-3 fw-semibold">{{$auditMonthlyCount}}</div>
                      <div class="fs-sm fw-semibold text-uppercase text-muted">This Month</div>
                    </div>
                  </div>
                </div>
              </a>
            </div>
            <!-- END Row #4 -->
          </div>
          <div class="row">
            <!-- Row #3 -->
            <div class="col-xl-8 d-flex align-items-stretch">
              <div class="block block-rounded block-themed block-mode-loading-dark block-transparent bg-image w-100" style="background-image: url({{ asset('media/photos/plane.jpg') }})">
                <div class="block-header bg-black-50">
                  <h3 class="block-title">
                    Aircrafts Management  <small class="text-white">System</small>
                  </h3>
                  <!-- <div class="block-options">
                    <button type="button" class="btn-block-option" data-toggle="block-option" data-action="state_toggle" data-action-mode="demo">
                      <i class="si si-refresh"></i>
                    </button>
                    < <button type="button" class="btn-block-option">
                      <i class="si si-wrench"></i>
                    </button> ->
                  </div> -->
                </div>
                <!-- <div class="block-content bg-black-50 p-1">
                  <!- Lines Chart Container functionality is initialized in js/pages/be_pages_dashboard.min.js which was auto compiled from _js/pages/be_pages_dashboard.js -->
                  <!-- For more info and examples you can check out http://www.chartjs.org/docs/ ->
                  <canvas id="js-chartjs-dashboard-lines"></canvas>
                </div> -->
              </div>
            </div>
            <div class="col-xl-4 d-flex align-items-stretch">
              <div class="block block-rounded block-transparent bg-primary-dark d-flex align-items-center w-100">
                <div class="block-content block-content-full">
                  <div class="py-3 px-3 border-black-op-b d-flex justify-content-between align-items-center">
                    <div>
                      <div class="fs-3 fw-semibold text-success">{{ $towercount }}</div>
                      <div class="fs-sm fw-semibold text-uppercase text-success-light">Aircrafts</div>
                    </div>
                    <div class="mt-3 d-none d-sm-block">
                      <i class="si si-book-open fa-2x text-success"></i>
                    </div>
                  </div>
                  <div class="py-3 px-3 border-black-op-b d-flex justify-content-between align-items-center">
                    <div>
                      <div class="fs-3 fw-semibold text-danger">{{$tenantcount}}</div>
                      <div class="fs-sm fw-semibold text-uppercase text-danger-light">Crew</div>
                    </div>
                    <div class="mt-3 d-none d-sm-block">
                      <i class="si si-book-open fa-2x text-danger"></i>
                    </div>
                  </div>
                  <div class="py-3 px-3 border-black-op-b d-flex justify-content-between align-items-center">
                    <div>
                      <div class="fs-3 fw-semibold text-warning">{{$maintenancecount}}</div>
                      <div class="fs-sm fw-semibold text-uppercase text-warning-light">Routine Maintenance</div>
                    </div>
                    <div class="mt-3 d-none d-sm-block">
                      <i class="si si-book-open fa-2x text-warning"></i>
                    </div>
                  </div>
                  <div class="py-3 px-3 border-black-op-b d-flex justify-content-between align-items-center">
                    <div>
                      <div class="fs-3 fw-semibold text-info">{{$auditcount}}</div>
                      <div class="fs-sm fw-semibold text-uppercase text-info-light">Scheduled Maintenance</div>
                    </div>
                    <div class="mt-3 d-none d-sm-block">
                      <i class="si si-book-open fa-2x text-info"></i>
                    </div>
                  </div>
                  <div class="py-3 px-3  d-flex justify-content-between align-items-center">
                    <div>
                      <div class="fs-3 fw-semibold text-elegance">{{$insurancecount}}</div>
                      <div class="fs-sm fw-semibold text-uppercase text-elegance-light">Insurance</div>
                    </div>
                    <div class="mt-3 d-none d-sm-block">
                      <i class="si si-book-open fa-2x text-elegance"></i>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <!-- END Row #3 -->
          </div>
          <div class="row">
            <!-- Row #4 >
            <div class="col-md-4">
              <div class="block block-rounded block-transparent bg-primary">
                <div class="block-content block-content-full">
                  <div class="py-3 text-center">
                    <div class="mb-3">
                      <i class="fa fa-envelope-open fa-4x text-primary-lighter"></i>
                    </div>
                    <div class="fs-4 fw-semibold text-white">19.5k Subscribers</div>
                    <div class="text-white-75">Your main list is growing!</div>
                    <div class="pt-3">
                      <a class="btn btn-alt-primary" href="javascript:void(0)">
                        <i class="fa fa-cog opacity-50 me-1"></i> Manage list
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-4">
              <div class="block block-rounded block-transparent bg-info">
                <div class="block-content block-content-full">
                  <div class="py-3 text-center">
                    <div class="mb-3">
                      <i class="fa fab fa-twitter fa-4x text-info-light"></i>
                    </div>
                    <div class="fs-4 fw-semibold text-white">+98 followers</div>
                    <div class="text-white-75">You are doing great!</div>
                    <div class="pt-3">
                      <a class="btn btn-alt-info" href="javascript:void(0)">
                        <i class="fa fa-users opacity-50 me-1"></i> Check them out
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-4">
              <div class="block block-rounded block-transparent bg-success">
                <div class="block-content block-content-full">
                  <div class="py-3 text-center">
                    <div class="mb-3">
                      <i class="fa fa-check fa-4x text-success-light"></i>
                    </div>
                    <div class="fs-4 fw-semibold text-white">Personal Plan</div>
                    <div class=" text-white-75">This is your current active plan</div>
                    <div class="pt-3">
                      <a class="btn btn-alt-success" href="javascript:void(0)">
                        <i class="fa fa-arrow-up opacity-50 me-1"></i> Upgrade to VIP
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <!-- END Row #4 -->
          </div>
        </div>
        <!-- END Page Content -->
@endsection
@section('js_after')
<script src="{{ asset('js/plugins/chartjs/Chart.bundle.min.js') }}"></script>
<script src="{{ asset('js/plugins/slick/slick.min.js') }}"></script>
<!-- <script src="{{ asset('js/pages/be_pages_dashboard.min.js')}}"></script> -->

<!-- Page JS Code -->
{{-- <script src="{{ asset('js/plugins/jquery-validation/jquery.validate.min.js') }}"></script>
<script src="{{ asset('js/plugins/jquery-validation/additional-methods.js') }}"></script> --}}
<script src="{{ asset('js/pages/be_pages_dashboard.js') }}"></script>
@endsection
