<?php

namespace App\Repositories\Dashboard;

use App\Repositories\Audit\AuditInterface;
use App\Repositories\AuditAgent\AuditAgentInterface;
use App\Repositories\Insurance\InsuranceInterface;
use App\Repositories\InsuranceCompany\InsuranceCompanyInterface;
use App\Repositories\Maintenance\MaintenanceInterface;
use App\Repositories\MaintenanceAgent\MaintenanceAgentInterface;
use App\Repositories\Tenant\TenantInterface;
use App\Repositories\Tower\TowerInterface;
use App\User;
use Carbon\Carbon;
use App\TenantTower;
use DB;

class DashboardRepository implements DashboardInterface
{


    private $tower;
    private $tenant;
    private $insurance;
    private $maintenance;
    private $audit;


    public function __construct(
        TowerInterface $tower,
        TenantInterface $tenant,
        InsuranceInterface $insurance,
        MaintenanceInterface $maintenance,
        AuditInterface $audit
    ) {
        $this->tower = $tower;
        $this->tenant = $tenant;
        $this->insurance = $insurance;
        $this->maintenance = $maintenance;
        $this->audit = $audit;
    }

    public function GetTowerCount(User $user = null)
    {

        if ($user) {



            return $this->tower->GetTowerCountByUser($user);
        }
        return $this->tower->GetTowerCount();
    }

    public function GetTenantOwnerTowerCount(User $user = null)
    {
        $towerowners = $this->tower->GetTowerByUser($user)->get();

        $tenants = array();
        if ($towerowners->count() > 0) {
            $towers = $towerowners[0]->towers;
            if ($towers->count() > 0) {

                foreach ($towers as $tower) {
                    //dd($tower->tenants->toArray());
                    $tenants =  array_merge($tenants, $tower->tenants->toArray());
                }
            }
        }


        // dd($tenants);
        return count($tenants);
    }

    public function GetTenantTowerCount(User $user = null)
    {


        if ($user) {
            //dd($user->id);

            // DB::enableQueryLog();

            // $count = $this->tenant->GetTenantCountByUser($user);

            // dd(DB::getQueryLog());
            // return $count;

            return $this->tenant->GetTenantCountByUser($user);
        }
        return $this->tenant->GetOccupiedTenantCount();
    }

    public function GetInsurancesCount(User $user = null)
    {
        if ($user) {

            return $this->insurance->GetAllInsurancesCountByUser($user);
        }
        return $this->insurance->GetAllInsurancesCount();
    }

    public function GetInsuranceCompanyTowerCount(User $user = null)
    {
        $towerowners = $this->tower->GetTowerByUser($user)->get();

        $insurancecompanies = array();
        if ($towerowners->count() > 0) {
            $towers = $towerowners[0]->towers;
            if ($towers->count() > 0) {

                foreach ($towers as $tower) {
                     //dd($tower->insurancecompanies->toArray());
                    $insurancecompanies =  array_merge($insurancecompanies, $tower->insurancecompanies->toArray());
                }
            }
        }


        return count($insurancecompanies);
    }

    public function GetMaintenancesCount(User $user = null)
    {
        if ($user) {

            return $this->maintenance->GetMaintenancesCountByUser($user);
        }
        return $this->maintenance->GetAllMaintenancesCount();
    }

    public function GetMaintenanceAgentTowerCount(User $user = null)
    {
        $towerowners = $this->tower->GetTowerByUser($user)->get();

        $maintenanceagents = array();
        if ($towerowners->count() > 0) {
            $towers = $towerowners[0]->towers;
            if ($towers->count() > 0) {

                foreach ($towers as $tower) {
                     //dd($tower->id);
                    $maintenanceagents =  array_merge($maintenanceagents, $tower->maintenanceagents->toArray());
                }
            }
        }


        return count($maintenanceagents);
    }

    public function GetAuditsCount(User $user = null)
    {
        if ($user) {

            return $this->audit->GetAuditAgentCountByUser($user);
        }
        return $this->audit->GetAuditAgentCount();
    }

    public function GetAuditAgentCount(User $user = null)
    {
        $towerowners = $this->tower->GetTowerByUser($user)->get();

        $auditagents = array();
        if ($towerowners->count() > 0) {
            $towers = $towerowners[0]->towers;
            if ($towers->count() > 0) {

                foreach ($towers as $tower) {
                     //dd($tower->$auditagents->toArray());
                    $auditagents =  array_merge($auditagents, $tower->auditagents->toArray());
                }
            }
        }

        return count($auditagents);
    }


    public function GetTowerWeeklyCount(User $user = null)
    {
        // if($user){

        //     return $this->tower->GetUserTowerWeeklyCount($user);
        // }
        return $this->tower->GetTowerWeeklyCount();
    }
    public function GetTowerMonthlyCount()
    {
        return $this->tower->GetTowerMonthlyCount();
    }
    public function GetTowerAverageCount()
    {
        return $this->tower->GetTowerAverageCount();
    }

    public function GetAuditsWeeklyCount()
    {
        return $this->audit->GetAuditsWeeklyCount();
    }
    public function GetAuditsMonthlyCount()
    {
        return $this->audit->GetAuditsMonthlyCount();
    }
    public function GetAuditsAverageCount()
    {
        return $this->audit->GetAuditsAverageCount();
    }
}
