<?php
namespace App\Repositories\Tenant;

use App\Tenant;
use App\TenantTower;
use App\User;
use App\Repositories\User\UserInterface;
use App\TenantUser;
use App\Repositories\Tower\TowerInterface;
use DB;

class TenantRepository implements TenantInterface
{
    public function SearchTenantByName($name)
    {
        return Tenant::where("name", "LIKE", "$name%")->get();
    }

    public function GetTenantByName($name)
    {
        return Tenant::where("name", $name)->first();
    }

    public function GetTenantById($tenantid)
    {
        return Tenant::find($tenantid);
    }

    public function CreateTenant($name)
    {
        return Tenant::create(["name"=>$name]);
    }

    public function GetOccupiedTenantCount()
    {
        //return $this->GetAllTenants()->count();
        return $this->GetAllTenantTowers()->count();
    }

    public function GetAllTenants()
    {
        return Tenant::all();
    }

    public function GetUserTenants(User $user)
    {
        $towerowners = $user->towerownerusers()->with('tower')->get()->pluck('tower');
    
        $tower_ids = $towerowners->pluck('id')->toArray();
    
        $tenants = TenantTower::whereIn('tower_id', $tower_ids)->get();
    
        //dd($tenants);
        return $tenants;
    }

    public function GetTenantByUser(User $user)
    {
        //dd($user->id);
       // dd($user->tenants());

        return $user->tenants();
    }

    public function GetTenantCountByUser(User $user)
    {
        # code...
        return $this->GetTenantByUser($user)->count();
    }

    public function GetAllTenantTowers()
    {

        return TenantTower::all();
    }
    public function GetAllPaginatedTenants()
    {
        return TenantTower::orderBy("id", 'DESC')->paginate(1000000);
    }
    public function CreateTenantUser($userid, $tenantid, $tenanttowerid=0){
        if($tenanttowerid>0){
            $tenant = GetTenantById($tenantid);
            return $tenant ->users()->attach($userid, ['tenant_tower_id'=>$tenanttowerid ]);

        }else{
            $tenant = $this->GetTenantById($tenantid);
            return $tenant->users()->attach($userid);
        }
    }
}
