<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\Pivot;

class MaintenanceAgentUser extends Model
{
    //
    protected $table = 'maintenance_agent_user';

    public $incrementing = true;

    public function user ()
    {
        return $this->belongsTo("App\User");
    }

    public function maintenanceengineer ()
    {
        return $this->belongsTo("App\MaintenanceEngineer");
    }

    public function maintenanceagent ()
    {
        return $this->belongsTo("App\MaintenanceAgent", "maintenance_agent_id");
    }   
}
