<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;
class User extends Authenticatable implements MustVerifyEmail
{
    use Notifiable, HasRoles, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'email', 'firstname', 'lastname', 'identity', 'password', 'isAdmin','email_token', 'user_id'
    ];

    

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function towerowners()
    {
        return $this->belongsToMany("App\TowerOwner")->using('App\TowerOwnerUser')->withPivot([
            'tower_id',
            'id'
        ])->withTimestamps();
    }

    public function tenants()
    {
        return $this->belongsToMany("App\Tenant")->using('App\TenantUser')->withPivot([
            'tenant_tower_id',
            'id'
        
        ])->withTimestamps();
    }

    
    public function tenantusers()
    {
        return $this->hasMany('App\TenantUser');
    }

    public function auditagents()
    {
        return $this->belongsToMany("App\AuditAgent")->using('App\AuditAgentUser')->withPivot([
            'audit_agent_tower_id',
            'id'
        ])->withTimestamps();
    }

    public function auditagentusers()
    {
        return $this->hasMany("App\AuditAgentUser");
    }

    public function maintenanceagents()
    {
        return $this->belongsToMany("App\MaintenanceAgent")->using('App\MaintenanceAgentUser')->withPivot([
            'maintenance_engineer_id',
            'id'
        ])->withTimestamps();
    }

    public function maintenanceagentusers()
    {
        return $this->hasMany("App\MaintenanceAgentUser");
    }

    public function insurancecompanies()
    {
        return $this->belongsToMany("App\InsuranceCompany")->using('App\InsuranceCompanyUser')->withPivot([
            'insurance_company_tower_id',
            'id'
        ])->withTimestamps();
    }

    public function insurancecompanyusers()
    {
        return $this->hasMany("App\InsuranceCompanyUser");
    }

    public function towerdraft()
    {
        return $this->hasOne("App\TowerDraft");
    }

    public function towerownerusers()
    {
        return $this->hasMany("App\TowerOwnerUser");
    }

    public function tower(){
        return $this->hasMany("App\Tower");
    }

    public function tenanttower()
    {
        return $this->hasMany("App\TenantTower");
    }

    public function tenanttowers()
    {
        return $this->belongsToMany("App\TenantTower");
    }

    public function towers()
    {
        return $this->belongsToMany('App\Tower', 'tenant_user', 'user_id', 'tenant_tower_id');
    }
}
