<?php

use App\Permission;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //
        $roles = [
            [
                'name' => 'admin',
                "guard_name" => "web",
                "description" => "Admin",
                "permissions" => ["view_towers_report", "view_tenants_report", "view_audits_report", "view_maintenances_report", "view_insurances_report", "admin_dashboard"]

            ], [
                'name' => 'towerowner',
                "guard_name" => "web",
                "description" => "towerowner",
                "permissions" => ["view_towers", "user_view_towers_report", "user_view_insurances_report", "user_view_maintenances_report", "user_view_audits_report", "user_view_tenants_report", "user_dashboard", "manage_tower"]
            ]
        ];
        for ($i = 0; $i < count($roles); $i++) {
            $role = new Role;
            $role->name = $roles[$i]["name"];
            $role->guard_name = $roles[$i]["guard_name"];
            $role->description = $roles[$i]["description"];
            $role->created_at = new DateTime();
            $permissions = $roles[$i]["permissions"];
            for ($j = 0; $j < count($permissions); $j++) {
                $permission = Permission::findByName($permissions[$j]);
                $role->givePermissionTo($permission);
            }
            $role->save();
        }
    }
}
