    
    <?php $__env->startSection(Auth::user()->isAdmin === 1?'contenta':'content'); ?>

         <!-- Full Table -->
         <div class="block">
            <div class="block-header block-header-default">
                <h3 class="block-title">List of Users</h3>
            </div>
            <div class="block-content">
                <?php if(Auth::user()->isAdmin): ?>
                    <a class="btn btn-info" href="<?php echo e(route('users.create')); ?>">Add</a>
                <?php else: ?>
                    <a class="btn btn-info" href="<?php echo e(route('portalsettings.users.create')); ?>">Add</a>
                <?php endif; ?>
                <div class="table-responsive">
                    <table class="table table-striped table-vcenter" id="table">
                        <thead>
                            <tr>
                                <th>S/N</th>
                                <th>Name</th>
                                <th>Username</th>
                                <th>Email</th>
                                <th>Role</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(++$i); ?></td>
                                    <td><?php echo e($user->firstname); ?> <?php echo e($user->lastname); ?></td>
                                    <td><?php echo e($user->username?$user->username:'no username'); ?></td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td>
                                        <?php $__empty_1 = true; $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php echo e($role->name); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            No role added
                                        <?php endif; ?>
                                     </td>
                                    <td>
                                        <?php if(!$user->email_verified_at): ?>
                                        <form class="d-inline" method="POST" action="<?php echo e(route('verification.resend')); ?>">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="resendverification">
                                        <input type="hidden" name="newuser" value="<?php echo e($user->id); ?>">
                                            <button type="submit" class="btn btn-info"><?php echo e(__('Resend verification Link')); ?></button>.
                                        </form>
                                        <?php endif; ?>
                                        <?php if(Auth::user()->isAdmin): ?>
                                        
                                        <a class="btn btn-primary" href="<?php echo e(route('users.edit',$user)); ?>">Edit</a>
                                        <?php echo Form::open(['method' => 'DELETE','route' => ['users.destroy', $user],'style'=>'display:inline']); ?>

                                            <?php echo Form::submit('Delete', ['class' => 'btn btn-danger']); ?>

                                        <?php echo Form::close(); ?>

                                        <?php else: ?>
                                        
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($users->links()); ?>

                </div>
            </div>
         </div>
    </div>
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('js_aftera'); ?>
    <script>
        //alert('hi');
        const deletefrms = document.querySelectorAll('.delete');
        deletefrms.forEach(deletefrm=>{
            deletefrm.addEventListener('submit', e =>{
                e.preventDefault();
                //alert('hi');
                const conf = confirm('are you sure you want to delete');
                conf? deletefrm.submit():"";
            });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(Auth::user()->isAdmin === 1?'layouts.portalsettings':'layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ncaa/public_html/resources/views/portalsettings/users/index.blade.php ENDPATH**/ ?>