<?php

namespace App\Repositories\Audit;

use App\AuditAgentTower;
use App\AuditAgentUser;
use App\User;
use App\Repositories\User\UserInterface;

interface AuditInterface
{
    public function SearchAuditAgentByName($auditagentname);

    public function GetAuditAgentByName($auditagentname);

    public function GetAuditAgentById($auditagentid);

    public function CreateAuditAgent($auditagentname);

    public function GetAuditAgentCount();

    public function GetAuditAgentTowerById($auditagenttowerid);

    public function UpdateAuditAgentTower(AuditAgentTower $auditagenttowerid);

    public function GetAllAuditTypes();

    public function GetAuditTypeByAuditAgentTowerId($auditagentowerid);

    public function GetAllTowerAudits();

    public function GetAllPaginatedTowerAudits();

    public function GetAuditsWeeklyCount();
    public function GetAuditsMonthlyCount();
    public function GetAuditsAverageCount();
    public function GetAuditAgentByUser(User $user);
    public function GetAuditAgentCountByUser(User $user);
    public function GetUserAudits(User $user);
}
