<!doctype html>
<html lang="en" class="no-focus">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">

        <title>Reset Password - National Central Tower</title>

        <meta name="description" content="national central tower powered by frm">
        <meta name="author" content="pixelcave">
        <meta name="robots" content="noindex, nofollow">

        <!-- Open Graph Meta -->
        <meta property="og:title" content="national central tower powered by frm">
        <meta property="og:site_name" content="national central tower">
        <meta property="og:description" content="national central tower powered by frm">
        <meta property="og:type" content="website">
        <meta property="og:url" content="">
        <meta property="og:image" content="">

        <!-- Icons -->
        <!-- The following icons can be replaced with your own, they are used by desktop and mobile browsers -->
        <link rel="shortcut icon" href="{{asset('media/favicons/favicon.png')}}">
        <link rel="icon" type="image/png" sizes="192x192" href="{{asset('media/favicons/favicon-192x192.png')}}">
        <link rel="apple-touch-icon" sizes="180x180" href="{{asset('media/favicons/apple-touch-icon-180x180.png')}}">
        <!-- END Icons -->

        <!-- Stylesheets -->

        <!-- Fonts and Codebase framework -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Muli:300,400,400i,600,700">
        <link rel="stylesheet" id="css-main" href="{{asset('css/codebase.css')}}">


        <!-- END Stylesheets -->
    </head>
    <body>


        <div id="page-container" class="main-content-boxed">

            <!-- Main Container -->
            <main id="main-container">
<!-- Fade In Modal -->
<div class="modal fade show" id="modal-large" tabindex="-1" role="dialog" aria-labelledby="modal-large" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="block block-themed block-transparent mb-0">
                <div class="block-header bg-primary-dark">
                    <h3 class="block-title">GENERAL INFORMATION</h3>
                    <div class="block-options">
                        <button type="button" class="btn-block-option" data-dismiss="modal" aria-label="Close">
                            <i class="si si-close"></i>
                        </button>
                    </div>
                </div>
                <div class="block-content">

                    <div class="d-flex flex-wrap">
                        <div class="block m-1">
                            <div class="block-header block-header-default">Requirements for Tower Maintenance Agent</div>
                            <div class="block-content">
                                <ol>
                                    <li>NCC Operating License.</li>
                                </ol>
                            </div>
                        </div>
                        <div class="block m-1">
                            <div class="block-header block-header-default">Requirements for Tower Insurance Firm</div>
                            <div class="block-content">
                                <ol>
                                    <li>TowerSITE Insurance Management System.</li>
                                    <li>NAICOM General Insurance Operating License.</li>
                                </ol>
                            </div>
                        </div>
                        <div class="block m-1">
                            <div class="block-header block-header-default">Requirements for Tower Audit Service Provider</div>
                            <div class="block-content">
                                <ol>
                                    <li>NCC Equipment Type Approval.</li>
                                    <li>TowerSITE UAV Mission Planner.</li>
                                    <li>ONSA Clearance.</li>
                                </ol>
                            </div>
                        </div>
                        <div class="block m-1">
                            <div class="block-header block-header-default">Requirements for Renewable Energy Service Provider</div>
                            <div class="block-content">
                                <ol>
                                    <li>NERC License.</li>
                                    <li>NCC Equipment Type Approval.</li>
                                    <li>TowerSITE System.</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-alt-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-alt-success" data-dismiss="modal">
                    <i class="fa fa-check"></i> Ok
                </button>
            </div>
        </div>
    </div>
</div>
<!-- END Fade In Modal -->
                <!-- Page Content -->
                <div class="bg-image" style="background-image: url({{asset('media/photos/photo34@2x.jpg')}});">

                    <div class="row mx-0 bg-black-op" data-toggle="appear">
                        <div class="hero-static flex-column col-md-6 col-xl-8 d-none d-md-flex align-items-md-end">
                            <div class="d-flex m-auto">
                                <div class="block">
                                    <div class="block-header block-header-default">GENERAL INFORMATION</div>
                                        <div class="block-content">
                                            <div class="d-flex">
                                                <div class="block m-1">
                                                    <div class="block-header block-header-default">Requirements for Tower Maintenance Agent</div>
                                                    <div class="block-content">
                                                        <ol>
                                                        <li>NCC Operating License.</li>
                                                        </ol>
                                                    </div>
                                                </div>
                                                <div class="block m-1">
                                                    <div class="block-header block-header-default">Requirements for Tower Insurance Firm</div>
                                                    <div class="block-content">
                                                        <ol>
                                                            <li>TowerSITE Insurance Management System.</li>
                                                            <li>NAICOM General Insurance Operating License.</li>
                                                        </ol>
                                                    </div>
                                                </div>
                                                <div class="block m-1">
                                                    <div class="block-header block-header-default">Requirements for Tower Audit Service Provider:</div>
                                                    <div class="block-content">
                                                        <ol>
                                                            <li>NCC Equipment Type Approval.</li>
                                                            <li>TowerSITE UAV Mission Planner.</li>
                                                            <li>ONSA Clearance.</li>
                                                        </ol>
                                                    </div>
                                                </div>
                                                <div class="block m-1">
                                                    <div class="block-header block-header-default">Requirements for Renewable Energy Service Provider</div>
                                                    <div class="block-content">
                                                        <ol>
                                                            <li>NERC License.</li>
                                                            <li>NCC Equipment Type Approval.</li>
                                                            <li>TowerSITE System.</li>
                                                        </ol>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>
                                </div>
                            </div>
                            <div class="p-3 invisible mt-auto" data-toggle="appear">
                                <p class="font-size-h3 mb-1 font-w600 text-white">
                                    National Central Tower
                                </p>
                                <p class="font-italic text-white-op">
                                    Copyright &copy; <span class="js-year-copy"></span> Powered by FRM
                                </p>
                            </div>
                        </div>
                        <div class="hero-static col-md-6 col-xl-4 d-flex align-items-center bg-white invisible" data-toggle="appear" data-class="animated fadeInRight">
                            <div class="content content-full">
                                <!-- Header -->
                                <div class="px-30 py-10">
                                    <a class="link-effect font-w700" href="/">
                                    <img src="{{asset('media/photos/ncc-logo.png')}}" style="height:50px; width:auto;" alt="">
                                        {{-- <span class="font-size-xl text-primary-dark">code</span><span class="font-size-xl">base</span> --}}
                                    </a>
                                    <h1 class="h3 font-w700 mt-30 mb-10">Reset Your Password</h1>
                                    <h2 class="h5 font-w400 text-muted mb-0">Enter new password. Password must be atleast 8 characters. </h2>
                                </div>
                                <!-- END Header -->
                                <div class="card-body">
                    <form method="POST" action="{{ route('password.update') }}">
                        @csrf

                        <input type="hidden" name="token" value="{{ $token }}">

                        <div class="form-group row">
                            <label for="email" class="col-md-4 col-form-label text-md-right">{{ __('E-Mail Address') }}</label>

                            <div class="col-md-6">
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password" class="col-md-4 col-form-label text-md-right">{{ __('Password') }}</label>

                            <div class="col-md-6">
                                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">

                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('Confirm Password') }}</label>

                            <div class="col-md-6">
                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('Reset Password') }}
                                </button>
                            </div>
                        </div>
                    </form>
                  
                </div>
                               
                </div>
            </div>
        </div>
    </div>
    <!-- END Page Content -->

</main>
<!-- END Main Container -->
</div>
<!-- END Page Container -->

<script src="{{asset('js/codebase.core.js')}}"></script>


<script src="{{asset('js/codebase.app.js')}}"></script>

</body>
</html>
