<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Repositories\Dashboard\DashboardInterface;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    private $dashboard;

    public function __construct(DashboardInterface $dashboard)
    {
        $this->dashboard = $dashboard;
    }
    public function index()
    {
        $user = Auth::user();
        $towercount = $this->dashboard->GetTowerCount($user);
        $tenantcount = $this->dashboard->GetTenantOwnerTowerCount($user);
        $insurancecount = $this->dashboard->GetInsuranceCompanyTowerCount($user);
        $maintenancecount = $this->dashboard->GetMaintenanceAgentTowerCount($user);
        $auditcount = $this->dashboard->GetAuditAgentCount($user);

        $towerWeeklyCount = $this->dashboard->GetTowerWeeklyCount($user);
        $towerMonthlyCount = $this->dashboard->GetTowerMonthlyCount($user);
        $towerAverage = $this->dashboard->GetTowerAverageCount($user);

        $auditWeeklyCount = $this->dashboard->GetAuditsWeeklyCount($user);
        $auditMonthlyCount = $this->dashboard->GetAuditsMonthlyCount($user);
        $auditAverage = $this->dashboard->GetAuditsAverageCount($user);


        return view('dashboards-user.index', compact('towercount', 'tenantcount', 'insurancecount', 'maintenancecount', 'auditcount', 'towerWeeklyCount', 'towerMonthlyCount', 'towerAverage', 'auditWeeklyCount', 'auditMonthlyCount', 'auditAverage'));
    }
}
