<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use App\Repositories\Report\ReportInterface;
use Illuminate\Http\Request;
use Auth;

class UserInsuranceController extends Controller
{
    private $report;

    public function __construct(ReportInterface $report)
    {
        $this->report = $report;
    }

    public function index(Request $request)
    {
        $user = Auth::user();
        $insurances = $this->report->GetAllInsurances($user);
        // dd($insuraces);
        return view('reports.users.insurances.index', compact('insurances'))->with('i', ($request->input('page', 1) - 1)* 5);
    }
}
