<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\Pivot;

class InsuranceCompanyUser extends Pivot
{
    //
    protected $table = 'insurance_company_user';

    public $incrementing = true;

    public function user ()
    {
        return $this->belongsTo("App\User");
    }

    public function insurancecompanytower ()
    {
        return $this->belongsTo("App\InsuranceCompanyTower");
    }

    public function insurancecompanies ()
    {
        return $this->belongsTo("App\InsuranceCompany", "insurance_company_id");
    }
}
