<?php
namespace App\Repositories\Report;

use App\Repositories\Audit\AuditInterface;
use App\Repositories\Insurance\InsuranceInterface;
use App\Repositories\Maintenance\MaintenanceInterface;
use App\Repositories\Tenant\TenantInterface;
use App\Repositories\Tower\TowerInterface;
use App\User;
use DB;

class ReportRepository implements ReportInterface
{
    private $tower;
    private $insurance;
    private  $tenant;
    private  $audit;
    private $maintenance;

    public function __construct(TowerInterface $tower,
    InsuranceInterface $insurance,
    TenantInterface $tenant, AuditInterface $audit, MaintenanceInterface $maintenance)
    {
        $this->tower = $tower;
        $this->insurance = $insurance;
        $this->tenant = $tenant;
        $this->audit = $audit;
        $this->maintenance = $maintenance;
    }

    public function GetAllTowers(User $user= null)
    {
        if($user){

            return $this->tower->GetUserTowers($user);

        }
        return $this->tower->GetAllPaginatedTowers();
    }

    public function GetAllInsurances(User $user=null)
    {
        if($user){

            return $this->insurance->GetUserInsurances($user);
        }
        return $this->insurance->GetAllPaginatedInsurances();
    }

    public function GetAllTenants(User $user =null)
    {
        if($user){

            return $this->tenant->GetUserTenants($user);

        }
        return $this->tenant->GetAllPaginatedTenants();
    }

    public function GetAllAudits(User $user = null)
    {
        if($user){

            return $this->audit->GetUserAudits($user);
        }
        return $this->audit->GetAllPaginatedTowerAudits();
    }

    public function GetAllMaintenances(User $user = null)
    {
        if($user){

            return $this->maintenance->GetUserMaintenances($user);
        }
        return $this->maintenance->GetAllPaginatedMaintenances();
    }
}
