<?php $__env->startSection('css_aftera'); ?>
    <style>
        .invalid-feedback{
            display: block;
        }

        .is-invalid {
            box-shadow: 0 1px 0 #ef5350 !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contenta'); ?>
    <div class="block">
        <div class="block-header block-header-default">
            <h3 class="block-title">Create Submenu</h3>
            <div class="block-options">
                <a href="<?php echo e(route('submenus.index')); ?>" class="btn-block-option">&#8592; back to Submenus</a>
            </div>
        </div>
        <div class="block-content">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <form action="<?php echo e(route('submenus.update', $submenu->id)); ?>" class=" <?php if($errors->any()): ?> was-valdated <?php endif; ?>" method="POST" id="edit">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
            <div class="form-group row">
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="form-material floating">
                        <select name="menu" id="menu" class="form-control">
                            <option value="" selected = "true">Select menu</option>
                            <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($menu->id); ?>/<?php echo e($menu->folder); ?>" <?php echo e(($menu->id === $submenu->menu->id? 'selected': "")); ?>><?php echo e($menu->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <label for="menu">Menu</label>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="form-material floating">
                        <?php echo Form::text('name', $submenu->name, array('class' => 'form-control', 'id'=>'name')); ?>

                        <label for="name">Name</label>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <span class="mt-auto pb-2 ml-4 folder border-bottom"><?php echo e($submenu->menu->folder); ?> /</span>
                <div class="col-xs-8 col-sm-8 col-md-8">
                    <div class="form-material floating">
                        <?php echo Form::text('url', $submenu->url, array('class' => 'form-control', 'id'=>'url')); ?>

                        <label for="url">URL</label>
                    </div>
                </div>
            </div>
            <?php if(count($permissions) > 0): ?>
                <div class="form-group row">
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-material floating open" id="permissionDiv">
                            <select name="permission" id="permission" class="form-control">
                                <option value="" selected = "true">Select permission</option>
                                <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value['id']); ?>" <?php echo e(( $submenu->permission? $value['id'] === $submenu->permission->id ? 'selected': "":"")); ?>><?php echo e($value['name']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <label for="permission"><?php echo e(__('Permission')); ?></label>
                        </div>
                        <?php $__errorArgs = ['permission'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <label class="css-control css-control-primary css-checkbox">
                            <input type="checkbox" id="addPermission" class="css-control-input" checked >
                            <span class="css-control-indicator"></span> <?php echo e(__('Add a permission')); ?>

                        </label>
                    </div>
                </div>
            <?php endif; ?>

            <div class="form-group row">
                <div class="col-xs-12 col-sm-12 col-md-6">
                    <div class="form-material">
                        <label class="css-control css-control-primary css-checkbox">
                            <input type="checkbox" id="is_visible" name="is_visible" class="css-control-input" value = true <?php echo e($submenu->is_visible == 1 ? 'checked' : ''); ?> >
                            <span class="css-control-indicator"></span> <?php echo e(__('Make Vissible')); ?>

                        </label>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-6">
                    <div class="form-material">
                        <label class="css-control css-control-primary css-checkbox">
                            <input type="checkbox" id="is_entry" name = "is_entry" class="css-control-input" value = true <?php echo e($submenu->is_entry == 1 ? 'checked' : ''); ?>  >
                            <span class="css-control-indicator"></span> <?php echo e(__('Make Entry')); ?>

                        </label>
                    </div>
                </div>
            </div>


            <div class="form-group row">
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="form-material floating">
                    <textarea name="description" id="description" cols="30" rows="10" class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e($submenu->description); ?></textarea>
                    <label for="description"><?php echo e(__('Description')); ?></label>
                    </div>
                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($message); ?></strong>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <div class="form-group row">
                <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Create')); ?></button>
                </div>
            </div>
            </form>
        <a href="<?php echo e(route('submenus.index')); ?>" class="nav-link">&#8592; back to Submenus</a>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js_aftera'); ?>
<script>
    const menu = document.querySelector("#menu");
    const url = document.querySelector("#url");
    const form = document.querySelector("#edit");
    let folder = document.querySelector('.folder');

    const addfolder = (value)=>{
        if(value !== ""){
            const foldername = value.split("/")[1];
            if(folder === null){
                folder = document.createElement("span");
                folder.classList.add('mt-auto','pb-2','ml-4', 'folder', 'border-bottom');
            }
            folder.textContent = `${foldername }  /`;
            // column = document.createElement("div");
            // column.classList.add('col-xs-4', 'col-sm-4', 'col-md-4');
            // column.appendChild(folder);
            url.parentElement.parentElement.classList.remove('col-xs-12', 'col-sm-12', 'col-md-12')
            url.parentElement.parentElement.classList.add('col-xs-8', 'col-sm-8', 'col-md-8')
            url.parentElement.parentElement.parentElement.insertBefore(folder, url.parentElement.parentElement);
        }else{
            if(folder !== null){
                url.parentElement.parentElement.classList.add('col-xs-12', 'col-sm-12', 'col-md-12')
                url.parentElement.parentElement.classList.remove('col-xs-8', 'col-sm-8', 'col-md-8')
                url.parentElement.parentElement.parentElement.removeChild(folder);
            }
        }
    };
    if(folder === null){
        addfolder(menu.options[menu.selectedIndex].value);
    }
    menu.addEventListener("change", (e)=>{
        const { value } = menu.options[menu.selectedIndex];
        addfolder(value);
    });


    form.addEventListener('submit', (e)=>{
        e.preventDefault();
        const { value } = menu.options[menu.selectedIndex];
        const menuid = value.split("/")[0];
        menu.options[menu.selectedIndex].value = menuid;
        form.submit();
    });
    const permission = document.querySelector('#permissionDiv');
    if(permission !== null){
        const permissionparent = permission.parentElement
        const togglePermissionOption = document.querySelector("#addPermission");
        togglePermissionOption.addEventListener("change", (e)=>{
            if(!togglePermissionOption.checked){
                togglePermissionOption.checked = true;
                permissionparent.removeChild(permission);
                togglePermissionOption.checked = false;
            }else{
                togglePermissionOption.checked = false;
                permissionparent.insertBefore(permission, togglePermissionOption.parentElement)
                togglePermissionOption.checked = true;

            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.portalsettings', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ncaa/public_html/resources/views/portalsettings/submenus/edit.blade.php ENDPATH**/ ?>