<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use App\Repositories\Report\ReportInterface;
use Illuminate\Http\Request;
use Auth;

class UserTowerController extends Controller
{
    private $report;

    public function __construct(ReportInterface $report)
    {
        $this->report = $report;
    }

    public function index(Request $request)
    {
        $user=Auth::user();
       // $id=$user->id;
        $towers = $this->report->GetAllTowers($user);
        
        return view('reports.users.towers.index', compact('towers'))->with('i', ($request->input('page', 1) - 1)* 5);
    }
}
