<?php

namespace App\Repositories\Insurance;

use App\InsuranceCompany;
use App\InsuranceCompanyTower;
use App\InsuranceLimit;
use App\InsurancePolicy;
Use App\User;
use App\InsuranceCompanyUser;
use App\Repositories\User\UserInterface;
use DB;

class InsuranceRepository implements InsuranceInterface
{
    public function GetAllInsuranceCompanies()
    {
        return InsuranceCompany::all();
    }

    public function GetAllInsurancesByUser(User $user){

        return $user-> insurancecompanies();

    }
    public function GetUserInsurances(User $user)
    {
        $towerowners = $user->towerownerusers()->with('tower')->get()->pluck('tower');
    
        $tower_ids = $towerowners->pluck('id')->toArray();
    
        $insurances = InsuranceCompanyTower::whereIn('tower_id', $tower_ids)->get();
    
        return $insurances;

    }

    public function GetAllInsurancesCount()
    {
        return $this->GetAllInsurances()->count();
    }
    public function GetAllInsurancesCountByUser(User $user){

        return $this -> GetAllInsurancesByUser($user)->count();

    }

    public function GetAllInsuranceLimits()
    {
        return InsuranceLimit::all();
    }

    public function GetInsuranceLimitById($insurancelimit)
    {
        return InsuranceLimit::find($insurancelimit);
    }

    public function GetAllInsurancePolicies()
    {
        return InsurancePolicy::all();
    }

    public function GetInsurancePolicyById($insurancepolicyid)
    {
        return InsurancePolicy::find($insurancepolicyid);
    }

    public function GetAllInsurances()
    {
        return InsuranceCompanyTower::all();
    }

    public function GetAllPaginatedInsurances()
    {
        return InsuranceCompanyTower::orderBy("id", 'DESC')->paginate(1000000);

    }
}
