@extends( Auth::user()->isAdmin === 1? 'layouts.portalsettings':'layouts.backend')
@section(Auth::user()->isAdmin === 1?'css_aftera':'css_after')
    <style>
        .invalid-feedback{
            display: block;
        }

        .is-invalid {
            box-shadow: 0 1px 0 #ef5350 !important;
        }
    </style>
@endsection
@section(Auth::user()->isAdmin === 1? 'contenta':'content')

<?php

// Function to generate a strong password
function generateStrongPassword($length = 12) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%^&*()_+[]{}|;:,.<>?';
    $charactersLength = strlen($characters);
    $password = '';

    for ($i = 0; $i < $length; $i++) {
        $password .= $characters[rand(0, $charactersLength - 1)];
    }

    return $password;
}

// // Check if the form is submitted
// if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    
//     // Collect form data
//     $firstname = $_POST['firstname'];
//     $othernames = $_POST['othernames'];
//     $lastname = $_POST['lastname'];
//     $email = $_POST['email'];
//     $role = $_POST['role'];
//     $isAdmin = isset($_POST['isAdmin']) ? 1 : 0;
    
    

//     // Generate a strong password
//     $plaintextPassword = generateStrongPassword();

//     // Hash the password
//     $hashedPassword = password_hash($plaintextPassword, PASSWORD_DEFAULT);

//     // Validate form data (add more validation as needed)
//     if (empty($firstname) || empty($lastname) || empty($email) || empty($role)) {
//         echo "All fields are required.";
//         // You may want to redirect back to the form with an error message
//         // header("Location: your_form_page.php?error=All fields are required");
//         // exit();
//     }


//     // Create a database connection (update with your credentials)
//     $servername = "localhost";
//     $username = "ncaa_portal";
//     $password = "ncaa_controlportal";
//     $dbname = "?)*Sx8_GBX1C";

//     $conn = new mysqli($servername, $username, $password, $dbname);

//     // Check the connection
//     if ($conn->connect_error) {
//         die("Connection failed: " . $conn->connect_error);
//     }

//     // Sanitize input data to prevent SQL injection
//     $firstname = mysqli_real_escape_string($conn, $firstname);
//     $othernames = mysqli_real_escape_string($conn, $othernames);
//     $lastname = mysqli_real_escape_string($conn, $lastname);
//     $email = mysqli_real_escape_string($conn, $email);
//     $role = mysqli_real_escape_string($conn, $role);

//     // Insert data into the database
//     $sql = "INSERT INTO your_users_table (firstname, othernames, lastname, email, role, isAdmin, password)
//             VALUES ('$firstname', '$othernames', '$lastname', '$email', '$role', '$isAdmin', '$hashedPassword')";

//     if ($conn->query($sql) === TRUE) {
//         echo "Record inserted successfully!";

//         // Send the plain text password to the user's email
//         $to = $email;
//         $subject = 'Your New Password';
//         $message = 'Your new password is: ' . $plaintextPassword;
//         $headers = 'From: webmaster@example.com';

//         mail($to, $subject, $message, $headers);

//         // You may want to redirect to a success page
//         // header("Location: success_page.php");
//         // exit();
//     } else {
//         echo "Error: " . $sql . "<br>" . $conn->error;
//         // You may want to redirect back to the form with an error message
//         // header("Location: your_form_page.php?error=Error inserting record");
//         // exit();
//     }

//     // Close the database connection
//     $conn->close();
// }

?>



    <div class="block">
        <div class="block-header block-header-default">
            <h3 class="block-title">Create Menu</h3>
            <div class="block-options">
                <a href="{{ route(Auth::user()->isAdmin?'users.index':'portalsettings.users.index') }}" class="btn-block-option">&#8592; back to users</a>
            </div>
        </div>
        <div class="block-content">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form method ="POST" action="{{ route('register') }}" class="@if ($errors->any()) was-valdated @endif">
                @csrf
                <div class="form-group row">
                    <div class="col-xs-4 col-sm-4 col-md-4">
                        <div class="form-material floating">
                            <input id="firstname" type="text" class="form-control @error('firstname') is-invalid @enderror" name="firstname" value="{{ old('firstname') }}" required autocomplete="off" autofocus>

                            <label for="firstname" class="">{{ __('First Name') }}</label>
                        </div>
                        @error('firstname')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-material floating">
                            <input id="othernames" type="text" class="form-control @error('othernames') is-invalid @enderror" name="othernames" value="{{ old('othernames') }}" autocomplete="off" autofocus>

                            <label for="othernames" class="">{{ __('Other Names') }}</label>
                        </div>
                        @error('othernames')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-material floating">
                            <input id="lastname" type="text" class="form-control @error('lastname') is-invalid @enderror" name="lastname" value="{{ old('lastname') }}" required autocomplete="off" autofocus>

                            <label for="lastname" class="">{{ __('Last Name') }}</label>
                        </div>
                        @error('name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                <div class="form-group row">
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-material floating">
                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="off">
                            <label for="email" class="">{{ __('E-Mail Address') }}</label>
                        </div>
                        @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-material floating open">
                        <select id="role" class="form-control @error('role') is-invalid @enderror" name="role[]"  required>
                                <option value="">Select a role</option>
                                @for ($i = 0; $i < count($roles); $i++)
                                    <option value="{{array_keys($roles)[$i]}}" {{ old('role') === array_keys($roles)[$i]? ' selected':'' }}>{{$roles[array_keys($roles)[$i]]}}</option>
                                @endfor
                            </select>
                            <label for="role" class="">{{ __('Role') }}</label>
                        </div>
                        @error('role')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                @if (Auth::user()->isAdmin === 1)
                    <div class="form-group row">
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <label class="css-control css-control-primary css-checkbox">
                                <input type="checkbox" id="isAdmin" name="isAdmin" class="css-control-input" checked value="1" >
                                <span class="css-control-indicator"></span> {{ __('Make system admin') }}
                            </label>
                        </div>
                    </div>
                @else
                    <input type="hidden" name="isAdmin" value="false" >
                @endif
                <div class="form-group row mb-0">
                    <div class="col-md-6 offset-md-4">
                        <button type="submit" class="btn btn-primary">
                            {{ __('Register') }}
                        </button>
                    </div>
                </div>
            </form>
            <a href="{{route('users.index')}}" class="nav-link">&#8592; back to users</a>
        </div>
    </div>
@endsection
@section(Auth::user()->isAdmin === 1?'js_aftera':'js_after')
    <script>
        const isAdmin = document.querySelector('#isAdmin');
        isAdmin.addEventListener("change", (e)=>{
            isAdmin.value = +isAdmin.checked
        })
    </script>
@endsection
