<!doctype html>
<html lang="<?php echo e(config('app.locale')); ?>" class="no-focus">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">

        <title> Aircrafts Management System Tower </title>

        <meta name="description" content="national central tower powered by frm">
        <meta name="author" content="national central tower powered by frm">
        <meta name="robots" content="noindex, nofollow">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <!-- for export -->
    

        <!-- Icons -->
        <link rel="shortcut icon" href="<?php echo e(asset('media/favicons/favicon.png')); ?>">
        <link rel="icon" sizes="192x192" type="image/png" href="<?php echo e(asset('media/favicons/favicon-192x192.png')); ?>">
        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('media/favicons/apple-touch-icon-180x180.png')); ?>">

        <!-- Fonts and Styles -->
        <?php echo $__env->yieldContent('css_before'); ?>
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Muli:300,400,400i,600,700">

        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,800&display=swap">
        <!-- <link rel="stylesheet" id="css-main" href="<?php echo e(asset('css/codebase.css')); ?>"> -->
        <link rel="stylesheet" id="css-main" href="<?php echo e(asset('css/codebase2.css')); ?>">

        <!-- DataTables Styles -->
        <!-- <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css"> -->
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.3.2/css/buttons.dataTables.min.css">

       <!-- <link rel="stylesheet" id="css-main" href="<?php echo e(mix('/css/codebase.css')); ?>"> -->

        <!-- You can include a specific file from public/css/themes/ folder to alter the default color theme of the template. eg: -->
        <!-- <link rel="stylesheet" id="css-theme" href="<?php echo e(mix('/css/themes/corporate.css')); ?>"> -->
        <?php echo $__env->yieldContent('css_after'); ?>

        <!-- Scripts -->
        <script>window.Laravel = <?php echo json_encode(['csrfToken' => csrf_token(),]); ?>;</script>
    </head>
    <body>
        <!-- Page Container -->
        <!--
            Available classes for #page-container:
        GENERIC
            'enable-cookies'                            Remembers active color theme between pages (when set through color theme helper Template._uiHandleTheme())
        SIDEBAR & SIDE OVERLAY
            'sidebar-r'                                 Right Sidebar and left Side Overlay (default is left Sidebar and right Side Overlay)
            'sidebar-mini'                              Mini hoverable Sidebar (screen width > 991px)
            'sidebar-o'                                 Visible Sidebar by default (screen width > 991px)
            'sidebar-o-xs'                              Visible Sidebar by default (screen width < 992px)
            'sidebar-inverse'                           Dark themed sidebar
            'side-overlay-hover'                        Hoverable Side Overlay (screen width > 991px)
            'side-overlay-o'                            Visible Side Overlay by default
            'enable-page-overlay'                       Enables a visible clickable Page Overlay (closes Side Overlay on click) when Side Overlay opens
            'side-scroll'                               Enables custom scrolling on Sidebar and Side Overlay instead of native scrolling (screen width > 991px)
        HEADER
            ''                                          Static Header if no class is added
            'page-header-fixed'                         Fixed Header
        HEADER STYLE
            ''                                          Classic Header style if no class is added
            'page-header-modern'                        Modern Header style
            'page-header-inverse'                       Dark themed Header (works only with classic Header style)
            'page-header-glass'                         Light themed Header with transparency by default
                                                        (absolute position, perfect for light images underneath - solid light background on scroll if the Header is also set as fixed)
            'page-header-glass page-header-inverse'     Dark themed Header with transparency by default
                                                        (absolute position, perfect for dark images underneath - solid dark background on scroll if the Header is also set as fixed)
        MAIN CONTENT LAYOUT
            ''                                          Full width Main Content if no class is added
            'main-content-boxed'                        Full width Main Content with a specific maximum width (screen width > 1200px)
            'main-content-narrow'                       Full width Main Content with a percentage width (screen width > 1200px)
        -->
        <div id="page-container" class="sidebar-o enable-page-overlay side-scroll page-header-modern main-content-boxed page-header-fixed sidebar-inverse ">
            <!-- Side Overlay-->
            <aside id="side-overlay">
                <!-- Side Header -->
                <div class="content-header content-header-fullrow">
                    <div class="content-header-section align-parent">
                        <!-- Close Side Overlay -->
                        <!-- Layout API, functionality initialized in Template._uiApiLayout() -->
                        <button type="button" class="btn btn-circle btn-dual-secondary align-v-r" data-toggle="layout" data-action="side_overlay_close">
                            <i class="fa fa-times text-danger"></i>
                        </button>
                        <!-- END Close Side Overlay -->

                        <!-- User Info -->
                        <div class="content-header-item">
                            <a class="img-link mr-5" href="javascript:void(0)">
                                <img class="img-avatar img-avatar32" src="<?php echo e(asset('media/avatars/avatar15.jpg')); ?>" alt="">
                            </a>
                            <a class="align-middle link-effect text-primary-dark font-w600" href="javascript:void(0)"><?php echo e(Auth::user()->firstname); ?><?php echo e(Auth::user()->othernames? ' '.Auth::user()->othernames: ''); ?> <?php echo e(Auth::user()->lastname); ?></a>
                        </div>
                        <!-- END User Info -->
                    </div>
                </div>
                <!-- END Side Header -->

                <!-- Side Content -->
                <div class="content-side">
                   <!-- Profile -->
                   <div class="block pull-r-l">
                    <div class="block-header bg-body-light">
                        <h3 class="block-title">
                            <i class="fa fa-fw fa-pencil font-size-default mr-5"></i>Profile
                        </h3>
                        <div class="block-options">
                            <button type="button" class="btn-block-option" data-toggle="block-option" data-action="content_toggle"></button>
                        </div>
                    </div>
                    <div class="block-content">

                        
                        <form action="<?php echo e(route('user.updatepassword')); ?>" method="post">                        
                            <?php echo csrf_field(); ?>
                            <?php echo method_field("PUT"); ?>
                            <div class="form-group mb-15">
                                <label for="side-overlay-profile-name">Name</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="side-overlay-profile-name" name="side-overlay-profile-name" placeholder="Your name.." disabled="disabled" value="<?php echo e(Auth::user()->firstname); ?><?php echo e(Auth::user()->othernames? ' '.Auth::user()->othernames: ''); ?> <?php echo e(Auth::user()->lastname); ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fa fa-user"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group mb-15">
                                <label for="side-overlay-profile-email">Email</label>
                                <div class="input-group">
                                    <input type="email" class="form-control" id="side-overlay-profile-email" name="side-overlay-profile-email" placeholder="Your email.." disabled="disabled" value="<?php echo e(Auth::user()->email); ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fa fa-envelope"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group mb-15">
                                <label for="current_password">Old Password</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="current_password" name="current_password" placeholder="Old Password..">
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fa fa-asterisk"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group mb-15">
                                <label for="new_password">New Password</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="new_password" name="new_password" placeholder="New Password..">
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fa fa-asterisk"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group mb-15">
                                <label for="new_confirm_password">Confirm New Password</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="new_confirm_password" name="new_confirm_password" placeholder="Confirm New Password..">
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fa fa-asterisk"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-6">
                                    <button type="submit" class="btn btn-block btn-alt-primary">
                                        <i class="fa fa-refresh mr-5"></i> Update
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- END Profile -->
                </div>
                <!-- END Side Content -->
            </aside>
            <!-- END Side Overlay -->

            <!-- Sidebar -->
            <!--
                Helper classes
                Adding .sidebar-mini-hide to an element will make it invisible (opacity: 0) when the sidebar is in mini mode
                Adding .sidebar-mini-show to an element will make it visible (opacity: 1) when the sidebar is in mini mode
                    If you would like to disable the transition, just add the .sidebar-mini-notrans along with one of the previous 2 classes
                Adding .sidebar-mini-hidden to an element will hide it when the sidebar is in mini mode
                Adding .sidebar-mini-visible to an element will show it only when the sidebar is in mini mode
                    - use .sidebar-mini-visible-b if you would like to be a block when visible (display: block)
            -->
            <nav id="sidebar" sidebar-inverse>
                <!-- Sidebar Content -->
                <div class="sidebar-content">
                    <!-- Side Header -->
                    <div class="content-header content-header-fullrow px-15" style="height: 100px">
                        <!-- Mini Mode -->
                        <div class="content-header-section sidebar-mini-visible-b">
                            <!-- Logo -->
                            <span class="content-header-item font-w700 font-size-xl float-left animated fadeIn">
                                <span class="text-dual-primary-dark">c</span><span class="text-primary">b</span>
                            </span>
                            <!-- END Logo -->
                        </div>
                        <!-- END Mini Mode -->

                        <!-- Normal Mode -->
                        <div class="content-header-section text-center align-parent sidebar-mini-hidden">
                            <!-- Close Sidebar, Visible only on mobile screens -->
                            <!-- Layout API, functionality initialized in Template._uiApiLayout() -->
                            <button type="button" class="btn btn-circle btn-dual-secondary d-lg-none align-v-r" data-toggle="layout" data-action="sidebar_close">
                                <i class="fa fa-times text-danger"></i>
                            </button>
                            <!-- END Close Sidebar -->

                            <!-- Logo -->
                            <div class="content-header-item">

                                <a class="link-effect font-w700" href="<?php echo e(url('https://ncc.gov.ng')); ?>">

                               <!-- conflict comment <a class="link-effect font-w700" href="/"> -->

                                    <img src="<?php echo e(asset('media/photos/nccalog.png')); ?>" style="height:100px;" />
                                </a>
                            </div>
                            <!-- END Logo -->

                        </div>
                        <!-- END Normal Mode -->
                    </div>
                    <!-- END Side Header -->
                    <!-- Side Navigation -->
                     <!-- Toggle Side Overlay -->
                                    <?php if(Auth::user()->isAdmin): ?>
                                        <div class="content-side content-side-full">
                      <?php echo Auth::user()->firstname; ?>
                        <ul class="nav-main">
                            <li>
                                <a href="https://ncaa.frmlimited.net/dashboards/admin">Dashboard</a>
                            </li>
                           <li> 
                                        <a class="" href="<?php echo e(route('reports.aircrafts.index')); ?>">Aircrafts</a></li>
                                        <li> <a class="" href="<?php echo e(route('reports.Crews.index')); ?>">Crews</a></li>
                                       <li> <a class="" href="<?php echo e(route('reports.insurances.index')); ?>">Insurance</a></li>
                                       <li>
                                        <a class="" href="<?php echo e(route('reports.RoutineMaintanance.index')); ?>">Routine  Maintanance</a></li>
                                        <li>
                                        <a class="" href="<?php echo e(route('reports.ScheduledMaintanance.index')); ?>">Scheduled  Maintanance</a></li>
                                        
                                    
                        </ul>
                    </div>
                                    <?php endif; ?>
                                    
                                    
                                    <?php if(!Auth::user()->isAdmin): ?>
                                    <div class="content-side content-side-full">
                                        <?php echo Auth::user()->firstname; ?>
                                        <ul class="nav-main">
                                            <li>
                                                <a href="https://ncaa.frmlimited.net/dashboards/user">Dashboard</a>
                                            </li>
                                             <li> 
                                        <a class="" href="<?php echo e(route('reports.users.aircrafts.index')); ?>">Aircrafts</a></li>
                                        <li> 
                                        <li> <a class="" href="<?php echo e(route('reports.users.Crews.index')); ?>">Crews</a></li>
                                        <a class="" href="<?php echo e(route('reports.users.insurances.index')); ?>">Insurance</a></li>
                                        <li>
                                        <a class="" href="<?php echo e(route('reports.users.RoutineMaintanance.index')); ?>">Routine  Maintanance</a></li>
                                         <a class="" href="<?php echo e(route('reports.users.ScheduledMaintanance.index')); ?>">Scheduled  Maintanance</a></li>
                                        
                                           
                                        </ul>
                                    </div>
                                <?php endif; ?>

                    
                    <!-- END Side Navigation -->
                </div>
                <!-- Sidebar Content -->
            </nav>
            <!-- END Sidebar -->

            <!-- Header -->
            <header id="page-header">
                <!-- Header Content -->
                <div class="content-header">
                    <!-- Left Section -->
                    <div class="content-header-section">
                        <!-- Toggle Sidebar -->
                        <!-- Layout API, functionality initialized in Template._uiApiLayout() -->
                        <button type="button" class="btn btn-circle btn-dual-secondary" data-toggle="layout" data-action="sidebar_toggle">
                            <i class="fa fa-navicon"></i>
                        </button>
                        <!-- END Toggle Sidebar -->

                        <!-- Open Search Section -->
                        <!-- Layout API, functionality initialized in Template._uiApiLayout() -->
                        
                        <!-- END Open Search Section -->

                        <!-- Layout Options (used just for demonstration) -->
                        <!-- Layout API, functionality initialized in Template._uiApiLayout() -->
                        
                        <!-- END Layout Options -->
                    </div>
                    <!-- END Left Section -->

                    <!-- Right Section -->
                    <div class="content-header-section">
                        <!-- User Dropdown -->
                        <div class="btn-group" role="group">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-rounded btn-dual-secondary" id="page-header-user-dropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-user d-sm-none"></i>
                                    <span class="d-none d-sm-inline-block"><?php echo e(Auth::user()->firstname); ?></span>
                                    <i class="fa fa-angle-down ml-5"></i>
                                </button>
                                <div class="dropdown-menu dropdown-menu-right min-width-200" aria-labelledby="page-header-user-dropdown"> 
                                    <a class="dropdown-item" href="javascript:void(0)" data-toggle="layout" data-action="side_overlay_toggle">
                                        <i class="si si-user mr-5"></i> Profile
                                    </a>
                                    <!-- Toggle Side Overlay -->
                                    <?php if(Auth::user()->isAdmin): ?>
                                         <div class="dropdown-divider"></div>
                                            <a class="dropdown-item" href="<?php echo e(route('roles.index')); ?>">
                                            <i class="si si-user mr-5"></i> Portal Setting
                                        </a>
                                    <?php endif; ?>

                                        <!-- Toggle Side Overlay -->

                                    <div class="dropdown-divider"></div>
                                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                       <i class="si si-logout mr-5"></i> <?php echo e(__('Logout')); ?>

                                    </a>


                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- END User Dropdown -->

                        <!-- Notifications -->
                        
                        <!-- END Notifications -->

                        <!-- Toggle Side Overlay -->
                        <!-- Layout API, functionality initialized in Template._uiApiLayout() -->
                        <button type="button" class="btn btn-circle btn-dual-secondary" data-toggle="layout" data-action="side_overlay_toggle">
                            <i class="fa fa-tasks"></i>
                        </button>
                        <!-- END Toggle Side Overlay -->
                    </div>
                    <!-- END Right Section -->
                </div>
                <!-- END Header Content -->

                <!-- Header Search -->
                <div id="page-header-search" class="overlay-header">
                    <div class="content-header content-header-fullrow">
                        <form action="/dashboards" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <!-- Close Search Section -->
                                    <!-- Layout API, functionality initialized in Template._uiApiLayout() -->
                                    <button type="button" class="btn btn-secondary" data-toggle="layout" data-action="header_search_off">
                                        <i class="fa fa-times"></i>
                                    </button>
                                    <!-- END Close Search Section -->
                                </div>
                                <input type="text" class="form-control" placeholder="Search or hit ESC.." id="page-header-search-input" name="page-header-search-input">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-secondary">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                   </div>
                </div>
                <!-- END Header Search -->

                <!-- Header Loader -->
                <!-- Please check out the Activity page under Elements category to see examples of showing/hiding it -->
                <div id="page-header-loader" class="overlay-header bg-primary">
                    <div class="content-header content-header-fullrow text-center">
                        <div class="content-header-item">
                            <i class="fa fa-sun-o fa-spin text-white"></i>
                        </div>
                    </div>
                </div>
                <!-- END Header Loader -->
            </header>
            <!-- END Header -->

            <!-- Main Container -->
            <main id="main-container">
                        <!-- Header Section -->
                    <!-- <div class="bg-image" style="background-image: url(<?php echo e(asset('media/photos/photo45.jpg')); ?>)"">
                    <div class="bg-primary-dark-op">
                        <div class="content content-full content-top">
                        <h1 class="py-5 text-white text-center">Welcome to your Dashboard <?php echo e(Auth::user()->firstname); ?></h1>
                        </div>
                    </div>
                    </div> -->
        <!-- END Header Section -->
                <?php if($message = Session::get('success')): ?>
                    <div class="alert alert-success">
                        <p><?php echo e($message); ?></p>
                    </div>
                <?php endif; ?>
                <?php if($message = Session::get('error')): ?>
                    <div class="alert alert-danger">
                        <p><?php echo e($message); ?></p>
                    </div>
                <?php endif; ?>
                <?php echo $__env->yieldContent('content'); ?>
            </main>
            <!-- END Main Container -->

            <!-- Footer -->
            <footer id="page-footer">
        <div class="content py-3">
          <div class="row fs-sm">
            <div class="col-sm-6 order-sm-2 py-1 text-center text-sm-end">
              Powered by <a class="fw-semibold" href="https://frmlimited.net/" target="_blank">FRM Communications</a>&copy; <span class="js-year-copy"></span>
            </div>
            <div class="col-sm-6 order-sm-1 py-1 text-center text-sm-start">
              <!-- <a class="fw-semibold" href="https://ncc.gov.ng" target="_blank">Nigerian Communications Commission</a> &copy; <span class="js-year-copy"></span> -->
            </div>
          </div>
        </div>
      </footer>
            <!-- END Footer -->
        </div>
        <!-- END Page Container -->

        

        <!-- Codebase Core JS -->
        
        <script src="<?php echo e(asset('js/codebase.app.js')); ?>"></script>
        <!-- <script src="<?php echo e(asset('js/pages/tables_datatables.js')); ?>"></script> -->
       <!-- conflict check <script src="<?php echo e(mix('js/codebase.app.js')); ?>"></script> -->

        <!-- Laravel Scaffolding JS -->
        <script src="<?php echo e(mix('js/laravel.app.js')); ?>"></script>

        <?php echo $__env->yieldContent('js_after'); ?>
        <!-- DataTables JS-->
        
        <script type="text/javascript" src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.3.2/js/dataTables.buttons.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.3.2/js/buttons.html5.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.3.2/js/buttons.print.min.js"></script>
       
        
    </body>
</html><?php /**PATH C:\xampp\htdocs\ncaa\resources\views/layouts/backend.blade.php ENDPATH**/ ?>